/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.jms;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.integrator.adaptors.jms.VWEventItem;
import filenet.vw.integrator.adaptors.jms.VWParameterItem;
import filenet.vw.integrator.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.table.AbstractTableModel;

public class VWEventTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 1;
    public static final int COL_NAME = 0;
    public static final int COL_DESCRIPTION = 1;
    private JDialog m_parentDialog = null;
    private Vector m_rowData = null;
    private boolean m_bIsModified = false;
    private String m_description = null;

    public VWEventTableModel(JDialog parentDialog) {
        try {
            this.m_parentDialog = parentDialog;
            this.m_rowData = new Vector();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWEventItem[] getEventItems() {
        Object[] eventItems = null;
        if (this.m_rowData != null) {
            eventItems = new VWEventItem[this.m_rowData.size()];
            this.m_rowData.copyInto(eventItems);
        }
        return eventItems;
    }

    public VWEventItem getRowItemAt(int nRowIndex) {
        VWEventItem eventItem = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            eventItem = (VWEventItem)this.m_rowData.elementAt(nRowIndex);
        }
        return eventItem;
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public void copyItem(int nRowIndex) {
        try {
            String copyOfString;
            VWEventItem newEventItem;
            VWEventItem eventItem = this.getRowItemAt(nRowIndex);
            if (eventItem != null && (newEventItem = this.createEventItem(copyOfString = VWResource.s_copyOf.toString(eventItem.getName()))) != null) {
                newEventItem.setDescription(eventItem.getDescription());
                VWParameterItem[] parameters = eventItem.getParameterItems();
                if (parameters != null) {
                    for (int nIndex = 0; nIndex < parameters.length; ++nIndex) {
                        VWParameterItem paramItem = parameters[nIndex];
                        newEventItem.createParameterItem(paramItem);
                    }
                }
                this.m_rowData.addElement(newEventItem);
                this.m_bIsModified = true;
                nRowIndex = this.getRowCount() - 1;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), 1);
        }
    }

    public void deleteItem(int nRowIndex) {
        try {
            VWEventItem eventItem = this.getRowItemAt(nRowIndex);
            this.m_rowData.removeElementAt(nRowIndex);
            this.m_bIsModified = true;
            this.fireTableRowsDeleted(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), 1);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_name;
            }
            case 1: {
                return VWResource.s_description;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWEventItem eventItem = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (eventItem != null) {
                        return eventItem.getName();
                    }
                    return new String();
                }
                case 1: {
                    if (eventItem != null) {
                        return eventItem.getDescription();
                    }
                    return this.m_description;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
                break;
            }
            case 1: {
                this.onUpdateDescription(aValue, nRowIndex);
            }
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        try {
            if (aValue == null || !(aValue instanceof String)) {
                return;
            }
            String newName = (String)aValue;
            if (newName.length() == 0) {
                return;
            }
            VWEventItem eventItem = this.getRowItemAt(nRowIndex);
            if (eventItem != null) {
                if (VWStringUtils.compare(newName, eventItem.getName()) == 0) {
                    return;
                }
                VWEventItem existingEventItem = this.getEventItem(newName);
                if (existingEventItem != null) {
                    throw new VWException("vw.integrator.eventAlreadyExists", "An event with this name already exists.");
                }
                eventItem.setName(newName);
                this.m_bIsModified = true;
                this.fireTableCellUpdated(nRowIndex, 0);
            } else {
                eventItem = this.createEventItem(newName);
                if (eventItem != null) {
                    eventItem.setDescription(this.m_description);
                    this.m_description = new String();
                    this.m_rowData.addElement(eventItem);
                    this.m_bIsModified = true;
                    this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentDialog, ex.getLocalizedMessage(), 1);
        }
    }

    private void onUpdateDescription(Object aValue, int nRowIndex) {
        try {
            if (aValue == null) {
                return;
            }
            VWEventItem eventItem = this.getRowItemAt(nRowIndex);
            if (eventItem != null) {
                eventItem.setDescription(aValue.toString());
                this.m_bIsModified = true;
            } else {
                this.m_description = aValue.toString();
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWEventItem createEventItem(String name) throws Exception {
        VWEventItem eventItem = this.getEventItem(name);
        if (eventItem != null) {
            throw new VWException("vw.integrator.eventAlreadyExists", "An event with this name already exists.");
        }
        return new VWEventItem(name);
    }

    public VWEventItem getEventItem(String name) {
        if (this.m_rowData != null) {
            for (int i = 0; i < this.m_rowData.size(); ++i) {
                VWEventItem eventItem = (VWEventItem)this.m_rowData.elementAt(i);
                if (eventItem == null || VWStringUtils.compare(eventItem.getName(), name) != 0) continue;
                return eventItem;
            }
        }
        return null;
    }
}

